/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util.maths;

import frc.emul.util.maths.MathUtils;
import java.awt.geom.Point2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CatmullRom {
    private static final boolean TANGENT_METHOD_LINEAR = true;
    private static final double TANGENT_FACTOR = 1.7;
    private static final double PI_2 = 1.5707963267948966;
    private static final double PI_4 = 0.7853981633974483;
    private final Point2D.Float tmpPt = new Point2D.Float();
    private Point2D.Float[] pts = null;

    public void fill(List<Point2D.Float> list, float[] fArray, float f) {
        int n = list.size();
        if (this.pts == null || this.pts.length != n + 4) {
            this.pts = new Point2D.Float[n + 4];
            this.pts[0] = new Point2D.Float();
            this.pts[1] = new Point2D.Float(0.0f, 0.0f);
            this.pts[n + 2] = new Point2D.Float(1.0f, 1.0f);
            this.pts[n + 3] = new Point2D.Float();
        }
        int n2 = list.size();
        while (n2-- > 0) {
            this.pts[n2 + 2] = list.get(n2);
        }
        MathUtils.fillCatmullRom(0.05f / f, this.tmpPt, this.pts, fArray);
    }

    public static final void adjustTangent(Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3, Point2D.Float float_4) {
        double d = (double)(float_2.y - float_.y) / (double)(float_2.x - float_.x);
        double d2 = Math.atan(d);
        double d3 = 0.7853981633974483 + (d2 - 0.7853981633974483) * 1.7;
        if (d3 > 1.5707963267948966) {
            d3 = 1.5707963267948966;
        } else if (d3 < 0.0) {
            d3 = 0.0;
        }
        double d4 = Math.tan(d3);
        double d5 = (double)float_3.y - (double)float_3.x * d4;
        if (d4 > 1.0) {
            float_4.x = (float)(((double)float_4.y - d5) / d4);
        } else {
            float_4.y = (float)(d4 * (double)float_4.x + d5);
        }
    }
}

